Attribute VB_Name = "Module2"
Option Explicit

Private Declare Function SetWindowsHookEx Lib "user32" Alias "SetWindowsHookExA" (ByVal idHook As Long, ByVal lpfn As Long, ByVal hmod As Long, ByVal dwThreadId As Long) As Long
Private Declare Function UnhookWindowsHookEx Lib "user32" (ByVal hHook As Long) As Long
Private Declare Function CallNextHookEx Lib "user32" (ByVal hHook As Long, ByVal ncode As Long, ByVal wParam As Long, lParam As Any) As Long
Private Declare Function GetTickCount Lib "kernel32" () As Long
Private Declare Function GetAsyncKeyState Lib "user32" (ByVal vKey As Long) As Integer


Public Const WH_CALLWNDPROC = 4
Public Const WH_CALLWNDPROCRET = 12
Public Const WH_CBT = 5
Public Const WH_DEBUG = 9
Public Const WH_FOREGROUNDIDLE = 11
Public Const WH_GETMESSAGE = 3
Public Const WH_HARDWARE = 8
Public Const WH_JOURNALPLAYBACK = 1
Public Const WH_JOURNALRECORD = 0
Public Const WH_KEYBOARD = 2
Public Const WH_MAX = 11
Public Const WH_MIN = (-1)
Public Const WH_MOUSE = 7
Public Const WH_MSGFILTER = (-1)
Public Const WH_SHELL = 10
Public Const WH_SYSMSGFILTER = 6

Public Const WM_QUEUESYNC = &H23

Public Const MSGF_DIALOGBOX = 0
Public Const MSGF_NEXTWINDOW = 6
Public Const MSGF_SCROLLBAR = 5
Public Const MSGF_MENU = 2

Public Const MSGF_MAINLOOP = 8      'Not used with MsgFilter Hook
Public Const MSGF_MAX = 8           'Not used with MsgFilter Hook
Public Const MSGF_MESSAGEBOX = 1    'Not used with MsgFilter Hook
Public Const MSGF_MOVE = 3          'Not used with MsgFilter Hook
Public Const MSGF_SIZE = 4          'Not used with MsgFilter Hook
Public Const MSGF_DDEMGR = &H8001   'Not used with MsgFilter Hook
Public Const MSGF_USER = 4096       'Not used with MsgFilter Hook

Public Const SC_ARRANGE = &HF110&
Public Const SC_CLOSE = &HF060&
Public Const SC_GROUP_IDENTIFIER = "+"
Public Const SC_HOTKEY = &HF150&
Public Const SC_HSCROLL = &HF080&
Public Const SC_KEYMENU = &HF100&
Public Const SC_MANAGER_CONNECT = &H1
Public Const SC_MANAGER_CREATE_SERVICE = &H2
Public Const SC_MANAGER_ENUMERATE_SERVICE = &H4
Public Const SC_MANAGER_LOCK = &H8
Public Const SC_MANAGER_MODIFY_BOOT_CONFIG = &H20
Public Const SC_MANAGER_QUERY_LOCK_STATUS = &H10
Public Const SC_MAXIMIZE = &HF030&
Public Const SC_MINIMIZE = &HF020&
Public Const SC_MOUSEMENU = &HF090&
Public Const SC_MOVE = &HF010&
Public Const SC_NEXTWINDOW = &HF040&
Public Const SC_PREVWINDOW = &HF050&
Public Const SC_RESTORE = &HF120&
Public Const SC_SCREENSAVE = &HF140&
Public Const SC_SIZE = &HF000&
Public Const SC_TASKLIST = &HF130&
Public Const SC_VSCROLL = &HF070&
Public Const SC_ICON = SC_MINIMIZE
Public Const SC_ZOOM = SC_MAXIMIZE
Public Const STANDARD_RIGHTS_REQUIRED = &HF0000
Public Const SC_MANAGER_ALL_ACCESS = (STANDARD_RIGHTS_REQUIRED Or SC_MANAGER_CONNECT Or SC_MANAGER_CREATE_SERVICE Or SC_MANAGER_ENUMERATE_SERVICE Or SC_MANAGER_LOCK Or SC_MANAGER_QUERY_LOCK_STATUS Or SC_MANAGER_MODIFY_BOOT_CONFIG)

Public Const SW_ERASE = &H4
Public Const SW_HIDE = 0
Public Const SW_INVALIDATE = &H2
Public Const SW_MAX = 10
Public Const SW_MAXIMIZE = 3
Public Const SW_MINIMIZE = 6
Public Const SW_NORMAL = 1
Public Const SW_OTHERUNZOOM = 4
Public Const SW_OTHERZOOM = 2
Public Const SW_PARENTCLOSING = 1
Public Const SW_PARENTOPENING = 3
Public Const SW_RESTORE = 9
Public Const SW_SCROLLCHILDREN = &H1
Public Const SW_SHOW = 5
Public Const SW_SHOWDEFAULT = 10
Public Const SW_SHOWMAXIMIZED = 3
Public Const SW_SHOWMINIMIZED = 2
Public Const SW_SHOWMINNOACTIVE = 7
Public Const SW_SHOWNA = 8
Public Const SW_SHOWNOACTIVATE = 4
Public Const SW_SHOWNORMAL = 1

Public Const SWP_FRAMECHANGED = &H20
Public Const SWP_DRAWFRAME = SWP_FRAMECHANGED
Public Const SWP_HIDEWINDOW = &H80
Public Const SWP_NOACTIVATE = &H10
Public Const SWP_NOCOPYBITS = &H100
Public Const SWP_NOMOVE = &H2
Public Const SWP_NOREDRAW = &H8
Public Const SWP_NOOWNERZORDER = &H200
Public Const SWP_NOREPOSITION = SWP_NOOWNERZORDER
Public Const SWP_NOSIZE = &H1
Public Const SWP_NOZORDER = &H4
Public Const SWP_SHOWWINDOW = &H40

Private Const HC_ACTION = 0
Private Const HC_GETNEXT = 1
Private Const HC_SKIP = 2
Private Const HC_NOREMOVE = 3
Private Const HC_NOREM = HC_NOREMOVE
Private Const HC_SYSMODALOFF = 5
Private Const HC_SYSMODALON = 4

Public Const HSHELL_ACTIVATESHELLWINDOW = 3
Public Const HSHELL_WINDOWCREATED = 1
Public Const HSHELL_WINDOWDESTROYED = 2
Public Const HSHELL_APPCOMMAND = 12
' #if(WINVER >= 0x0400)
Public Const HSHELL_WINDOWACTIVATED = 4
Public Const HSHELL_GETMINRECT = 5
Public Const HSHELL_REDRAW = 6
Public Const HSHELL_TASKMAN = 7
Public Const HSHELL_LANGUAGE = 8
' #if(_WIN32_WINNT >= 0x0500)
Public Const HSHELL_ACCESSIBILITYSTATE = 11
Public Const ACCESS_STICKYKEYS = &H1
Public Const ACCESS_FILTERKEYS = &H2
Public Const ACCESS_MOUSEKEYS = &H3

Public Const HCBT_MOVESIZE = 0
Public Const HCBT_MINMAX = 1
Public Const HCBT_QS = 2
Public Const HCBT_CREATEWND = 3
Public Const HCBT_DESTROYWND = 4
Public Const HCBT_ACTIVATE = 5
Public Const HCBT_CLICKSKIPPED = 6
Public Const HCBT_KEYSKIPPED = 7
Public Const HCBT_SYSCOMMAND = 8
Public Const HCBT_SETFOCUS = 9

Public Const VK_ESCAPE = &H1B


Private Type EVENTMSG
        message As Long
        paramL As Long
        paramH As Long
        time As Long
        hwnd As Long
End Type

Public Type DEBUGHOOKINFO
        hModuleHook As Long
        Reserved As Long
        lParam As Long
        wParam As Long
        code As Long
End Type

Public Type POINTAPI
        x As Long
        y As Long
End Type

Public Type MSG
    hwnd As Long
    message As Long
    wParam As Long
    lParam As Long
    time As Long
    pt As POINTAPI
End Type

Public Type RECT
        Left As Long
        Top As Long
        Right As Long
        Bottom As Long
End Type

Public Type CREATESTRUCT
        lpCreateParams As Long
        hInstance As Long
        hMenu As Long
        hWndParent As Long
        cy As Long
        cx As Long
        y As Long
        x As Long
        style As Long
        lpszName As String
        lpszClass As String
        ExStyle As Long
End Type

Public Type CBT_CREATEWND
        lpcs As CREATESTRUCT
        hWndInsertAfter As Long
End Type

Public Type CBTACTIVATESTRUCT
        fMouse As Long
        hWndActive As Long
End Type

Public Type MOUSEHOOKSTRUCT
        pt As POINTAPI
        hwnd As Long
        wHitTestCode As Long
        dwExtraInfo As Long
End Type


Private hHook As Long
Private hDbgHook As Long

Public IsHooked As Boolean
Public IsDBGHooked As Boolean
Public IsPBHooked As Boolean



'-----------------------------
' SET MESSAGE FILTER HOOK
'-----------------------------
Public Sub SetCBTHook()
    If IsHooked Then
        MsgBox "Don't hook CBT twice or you will be unable to unhook it."
    Else
        hHook = SetWindowsHookEx(WH_CBT, AddressOf CBTProc, 0, App.ThreadID)
        IsHooked = True
    End If
End Sub

Public Sub RemoveCBTHook()
    Dim temp As Long
    temp = UnhookWindowsHookEx(hHook)
    IsHooked = False
End Sub


Public Function CBTProc(ByVal uCode As Long, ByVal wParam As Long, ByVal lParam As Long) As Long
    If uCode >= 0 Then
        Select Case uCode
            Case HCBT_ACTIVATE
                'wParam == Specifies the handle to the window about to be activated
                'lParam == Pointer to the CBTACTIVATESTRUCT struct
                Form2.Text1.Text = Form2.Text1.Text & "HCBT_ACTIVATE    HWND:" & wParam & vbNewLine
            Case HCBT_CLICKSKIPPED
                'wParam == Specifies the mouse message removed from the system message queue
                'lParam == Pointer to the MOUSEHOOKSTRUCT struct
                'Form2.Text1.Text = Form2.Text1.Text & "HCBT_CLICKSKIPPED    MouseMsg:" & wParam & vbNewLine
            Case HCBT_CREATEWND
                'wParam == Specifies the handle to the new window
                'lParam == Pointer to the CBT_CREATEWND struct
                Form2.Text1.Text = Form2.Text1.Text & "HCBT_CREATEWND    NEW_HWND:" & wParam & "    lParam:" & lParam & vbNewLine
                Exit Function 'Otherwise a GPF occurs in the CallNextHookEx function
            Case HCBT_DESTROYWND
                'wParam == Specifies the handle to the window about to be destroyed
                'lParam == 0
                Form2.Text1.Text = Form2.Text1.Text & "HCBT_DESTROYWND    Destroyed_HWND:" & wParam & vbNewLine
            Case HCBT_KEYSKIPPED
                'wParam == Specifies the virtual-key code
                'lParam == Specifies the repeat count, scan code, key-transition code, previous key state, and context code
                Form2.Text1.Text = Form2.Text1.Text & "HCBT_KEYSKIPPED    Virtual-Key Code:" & wParam & "    Misc_Params:" & lParam & vbNewLine
            Case HCBT_MINMAX
                'wParam == Specifies the handle to the window being minimized or maximized
                'lParam == Specifies, in the low-order word, a show-window value (SW_) specifying the operation,
                '          The high order word is undefined
                Form2.Text1.Text = Form2.Text1.Text & "HCBT_MINMAX    HWND:" & wParam & "    lParam:" & (&HFFFF And lParam) & vbNewLine
            Case HCBT_MOVESIZE
                'wParam == Specifies the handle to the window to be moved or sized
                'lParam == Pointer to a RECT struct
                Form2.Text1.Text = Form2.Text1.Text & "HCBT_MOVESIZE    HWND:" & wParam & vbNewLine
            Case HCBT_QS
                'wParam == 0
                'lParam == 0
                Form2.Text1.Text = Form2.Text1.Text & "HCBT_QS" & vbNewLine
            Case HCBT_SETFOCUS
                'wParam == Specifies the handle to the window gaining the keyboard focus
                'lParam == Specifies the handle to the window losing the keyboard focus
                Form2.Text1.Text = Form2.Text1.Text & "HCBT_SETFOCUS    New_HWND:" & wParam & "    Old_HWND:" & lParam & vbNewLine
            Case HCBT_SYSCOMMAND
                'wParam == Specifies a system-command value (SC_*) specifying the system command
                'lParam == Contains the same data as the lParam value of a WM_SYSCOMMAND message
                Form2.Text1.Text = Form2.Text1.Text & "HCBT_SYSCOMMAND    System_Command:" & wParam & "    lParam:" & lParam & vbNewLine
        End Select
    End If
    
    If uCode = HCBT_MOVESIZE Then
        CBTProc = 1
    Else
        CBTProc = CallNextHookEx(hHook, uCode, wParam, lParam)
    End If
End Function




'-----------------------------
' SET DEBUG FILTER HOOK
'-----------------------------
Public Sub SetDebugHook()
    If IsDBGHooked Then
        MsgBox "Don't hook WH_DEBUG twice or you will be unable to unhook it."
    Else
        hDbgHook = SetWindowsHookEx(WH_DEBUG, AddressOf DebugProc, 0, App.ThreadID)
        IsDBGHooked = True
    End If
End Sub

Public Sub RemoveDebugHook()
    Dim temp As Long
    temp = UnhookWindowsHookEx(hDbgHook)
    IsDBGHooked = False
End Sub


Public Function DebugProc(ByVal uCode As Long, ByVal wParam As Long, lParam As DEBUGHOOKINFO) As Long
    
    'If nCode is HC_ACTION, the hook procedure must process the message
    
    If uCode < 0 Then
        DebugProc = CallNextHookEx(hDbgHook, uCode, wParam, lParam)
    Else
        Select Case wParam
            Case WH_CBT
                Form2.Text1.Text = Form2.Text1.Text & "WH_CBT    CODE:" & lParam.code & "    WPARAM:" & lParam.wParam & "    LPARAM:" & lParam.lParam & vbNewLine
            Case WH_JOURNALPLAYBACK
                Form2.Text1.Text = Form2.Text1.Text & "WH_JOURNALPLAYBACK    CODE:" & lParam.code & "    WPARAM:" & lParam.wParam & "    LPARAM:" & lParam.lParam & vbNewLine
            Case WH_JOURNALRECORD
                Form2.Text1.Text = Form2.Text1.Text & "WH_JOURNALRECORD" & vbNewLine
            Case WH_KEYBOARD
                Form2.Text1.Text = Form2.Text1.Text & "WH_KEYBOARD    CODE:" & lParam.code & "    WPARAM:" & lParam.wParam & "    LPARAM:" & lParam.lParam & vbNewLine
            Case WH_MOUSE
                Form2.Text1.Text = Form2.Text1.Text & "WH_MOUSE    CODE:" & lParam.code & "    WPARAM:" & lParam.wParam & "    LPARAM:" & lParam.lParam & vbNewLine
        End Select
            
        'To prevent the system from calling the hook, the hook procedure must return a nonzero value
        DebugProc = CallNextHookEx(hDbgHook, uCode, wParam, lParam)
    End If
End Function

